# 

dir=$(dirname "$0")

export PATH="$(pwd)/tests/bin":$PATH

. "$dir"/test-lib.sh

setup

desc 'setup.py without arguments'
fails '/@unixroot/usr/bin/python3 setup.py'
succeeds '/@unixroot/usr/bin/python3 setup.py 2>&1 |grep "usage: setup.py"'

desc 'setup.py --help'
succeeds '/@unixroot/usr/bin/python3 setup.py --help'
# .* = Unix|Windows
succeeds '/@unixroot/usr/bin/python3 setup.py --help |grep "PycURL .* options:"'
# distutils help
succeeds '/@unixroot/usr/bin/python3 setup.py --help |grep "Common commands:"'

desc 'setup.py --help with bogus --curl-config'
succeeds '/@unixroot/usr/bin/python3 setup.py --help --curl-config=/dev/null'
succeeds '/@unixroot/usr/bin/python3 setup.py --help --curl-config=/dev/null |grep "PycURL .* options:"'
# this checks that --curl-config is consumed prior to
# distutils processing --help
fails '/@unixroot/usr/bin/python3 setup.py --help --curl-config=/dev/null 2>&1 |grep "option .* not recognized"'
