# History of changes for LIBC Next

#### Version 0.1.14 (2026-01-11)

* exceptions: Add support for EXCEPTQ_DEBUG_EXCEPTION [#148].
* exceptions: Fix moving EXCEPTQ reports triggerd more often than once a second [#148].
* exceptions: Add __libc_debug_report to force EXCEPTQ debug exception [#148].
* exceptions: Add __libc_debug_report_n convenience macro [#148].
* umalloc: Release heap lock on assert [#130].
* Enable non-POSIX hton*, gethostid, gethostname in BSD mode [#135].
* Add arc4random_buf [#151].
* __spawnve: Properly handle shebang lines in non-kLIBC mode [#152].
* __spawnve: Replace non-standard stdio handles with pipes for non-kLIBC processes [#150].
* __spawnve: Fix incorrect EBADF instead of ENOEXEC [#150].
* fcntl: Support F_CLOSEM and F_MAXFD commands [#153].
* tcpip: Call so_cancel when closing OS/2 socket [#150].
* Add closefrom and close_range [#153].
* fs: Support F_[G|S]ETF[D|L] in Directory Access backend [#154].
* logging: Add TLS log group.
* logstrict: Do not split ErrL messages.
* logstrict: Fix printing unsigned [long] long with high bit set.
* logstrict: Improve log header (codepage, kLIBC args).
* logstrict: Add UTF-8 support for log files, "%hc" and "%hs" format specifiers.
* logstrict: Add *_STRICT versions of LIBC_ASSERT_* macros.
* wait[pid|3|4]: Preserve child exit code on abnormal termination by signals [#136].
* __spawni: Fix order of posix_spawn[p] calls based on use_path [#144].
* getrlimit: Properly report high memory [#143].
* fork: Deregister DLL on init failure instead of registering it again [#140].
* posix_spawn_file_action_addopen: Make copy of path [#146].
* Add wcscasecmp and wcsncasecmp [#149].
* Make putenv, initstate, srandom, iconv POSIX compatible [#142].
* freopen: Fix returning NULL on success w/o fname [#160].
* exec/spawn: Do not accept dirs on interpreter probes [#166].
* wmemcmp: Fix one-off typo in returned value [#168].
* strcoll: Fix 1-byte char comparison in MBCS mode [#167].
* pathconf: Accept paths with trailing slashes [#162].
* open(dir): Fix Inode/Dev assignment [#161].
* dup2: Return EBADF if target fd is out of range [#171].

#### Version 0.1.13 (2024-08-03)

* sys/timeb.h: Sync time_t typedef with the rest via __time_t [#137].
* errno: Enable non-POSIX codes in BSD mode [#136].
* remove: Add support for deleting directories [#138].
* termios.h: Enable non-POSIX codes in BSD mode [#135].
* startup: flush streams explicitly in _CRT_term() [#139].

#### Version 0.1.12 (2023-09-11)

* Export internal ___libc_touch call from LIBC DLL for libsocket [#133].

#### Version 0.1.11 (2023-08-30)

* readv/writev: Use IOV_MAX instead of hard-coded value [#126].
* logstrict: Create reports/logs in BOOTDRIVE\var\log\app if no LOGFILES or UNIXROOT set [#115].
* Return E2BIG for OS/2 ERROR_BAD_ENVIRONMENT and ERROR_BAD_ARGUMENTS [#127].
* spawn: Support large environment and command line for kLIBC apps [#127].
* spawn: Support large command line & environment in hash bang scripts [#127].
* Bump _XOPEN_SOURCE to 700 [#128].
* errno: Make EWOULDBLOCK, ETXTBSY and others available in POSIX mode [#124].
* Add BLDLEVEL info to LIBCn DLLs [#67].
* ibsocket: recv: Touch buffer to mmake LIBCx mmap machinery work [#123].
* sys/cdefs.h: Set __ISO_C_VISIBLE to 2011 by default to match current GCC [#131].
* assert.h: Add static_assert macro (C11 standard) [#131].

#### Version 0.1.10 (2022-03-22)

* Call non-OS/2 handle close callback upon unexpected handle loss [#117].
* Add usual enter/exit logging to more I/O APIs [#117].
* fwrite: Don't return EOL [#120].
* Add missing scandir and alphasort definitions [#52].
* Import wcsdup.c from FreeBSD and align to EMX [#118, #119].
* unistd.h: Align crypt and friends to crypt.h [#121].

#### Version 0.1.9 (2021-08-26)

* logstrict: Fix crash when logging with no groups provided [#112].
* logstrict: Add `__LIBC_LOG_MSGF_ALWAYS` to ignore log groups when writing message [#113].
* Append LIBC DLL module handle to its shared mutex/memory names [#114].

#### Version 0.1.8 (2021-08-16)

* Make environ properly reflect empty environment on startup [#100].
* spawnve: Skip empty strings in envp argument [#100].
* setenv: Avoid arbitrary memory overwrite when replacing vars with no `=` [#102].
* Fix Y2038 bug in DST handling for timezones with DST [#109].
* Change defalt SIGTRAP action to terminate + "core dump" [#111].
* emx/io.h: Prefix nbuf, cbuf, ubuf etc. macros with underscore [#107].
* logging: Fix handling lowercase log groups [#101].
* logstrict: Create log files in system log directory by default [#101].
* logstrict: Make `__libc_LogAssert` work even on log file creation failure [#101].
* Move EXCEPTQ .TRP reports generated by LIBC to system log directory [#99].
* \_isterm: Make it return non-zero only for real console (kbd/scr) devices [#105].

#### Version 0.1.7 (2021-02-26)

* libsocket: Retry after bogus ENOTSOCK in socketpair [#94].
* Add support for EXCEPTQ to LIBC panic handler [#96].
* Fix false wait loop break in `_fmutex_request_internal` [#97].
* Retry on ERROR_INTERRUPT in dosexRequestMutex [bitwiseworks/qtwebengine-chromium-os2#12].

#### Version 0.1.6 (2020-12-31)

* Implement `sysconf(_SC_NPROCESSORS_CONF)` (addon to [#5]).
* Fix broken nearbyint returning arbitrary values [#87].
* select: Return -1 and ENIVAL when nfds < 0 or > FD_SETSIZE [#91].
* Make `tzset`, `__ftime` and `gethrtime` thread safe [#90].
* Use `socklen_t` in socket function prototypes [#63].

#### Version 0.1.5 (2020-07-22)

* Make realpath not fail on long paths with lots of '..' and '.' [#73].
* emxomf: Provide more verbose `Record too long` error message [#74].
* emxomf: Fix `Record too long` error for objects with really long names [#74].
* sys/socket.h: Use void * instead of caddr_t in msghdr [bitwiseworks/qtwebengine-chromium-os2#3].
* Implement sysconf for _SC_PHYS_PAGES and _SC_AVPHYS_PAGES [#79].
* Make timeval::tv_sec have type time_t instead of long as per POSIX [#80].
* emxomfld: Add simple profiling in -t -t -t mode [#83].
* emxomfld: Backport kLIBC r3669 [#83].
* emxomf[ld]: Greatly increase hash table sizes to speed things up [#83].

#### Version 0.1.4 (2020-03-27)

* Add more errors to strerror/perror [#8].
* sys/stat.h: Swap st_mtim and st_mtimespec and friends [#45].
* Add wide char output functions (wprintf, putwc and families) [#8].
* Fix WCHAR_MIN/MAX and WINT_MIN/MAX definitions [#8].
* b_timeHighResNano: Use integer arithmetics [#53].
* Add clock_gettime and friends [#53].
* Implement POSIX semaphores [#54].
* Make new POSIX 2008 string functions available by default [#57].
* Make isblank available by default [#61].
* _sockaddr_storage.h: Change alignment to 32 bits [#62].
* sys/socket.h: Add socklen_t, sa_family_t, sockaddr_storage [#62].
* select: Do a simple wait cycle when nfds is 0 [bitwiseworks/libevent-os2#1].
* Add wide char output functions (wscanf, getwc and families) [#8].
* Add fgetws and fputws wide char functions [#8].
* math.h: Align with latest FreeBSD [bitwiseworks/gcc-os2#15].
* Add wcsxfrm function [#68].
* sys/socket.h: Add SHUT_* constants for shutdown() [bitwiseworks/qtwebengine-chromium-os2#3].
* signal.h: Force si_code constants to be (signed) int [bitwiseworks/qtwebengine-chromium-os2#3].

#### Version 0.1.3 (2019-12-25)

* Restrict 2-nd `__cxchg` operand to A/B/C/D registers [#47].
* symlink: Return EEXIST if path name exists and is directory [#48].
* posix_spawn: Return errno on failure instead of -1 [#46].
* sys/stat.h: Add more BSD-like aliases like st_mtimensec and st_mtim [#45].
* Rebuild with newer libiberty (binutils 2.33.1) to fix EMXOMF crash [#49].

#### Version 0.1.2 (2019-07-15)

* Get rid of direct resolving of DosOpenL and friends. [#36].
* unlink() shall not delete directories, but return EISDIR [upstream].
* Make _fnlwr/_fnlwr2 work for path rewrites (/@unixroot and such) [#39].
* Provide pwd_mkdb tool that handles : to $ replacement in drive names in pw_dir [#1].
* Add getrusage() implementation [#40].

#### Version 0.1.1 (2019-02-24)

* Fix failures to fork children from drive root directory [#31].
* Silence emxomf warnings not fixable by programmer [#32].

#### Version 0.1.0 (2019-02-15)

* Initial release of LIBC Next based on kLIBC version 0.6.6 CSD6 (released on 27-10-2014). The below list of changes shows important changes, improvements and fixes since this version.
* Change main LIBC DLL name from LIBC066.DLL to LIBCN0.DLL [#17].
* Add bww copyright and git commit information to all binaries and DLLs [#17].
* Change LIBC global mutex and shared memory names from INNOTEKLIBC to BWWLIBC [#17].
* Add \__LIBCN\__, \__LIBCN_MINOR\__, __LIBCN_PREREQ defines to features.h [#29].
* Fix resetting file access mode to O_WRONLY if opened with O_NOINHERIT [#2].
* Define __LONG_LONG_SUPPORTED on modern C++ (C++11 and above) [#3].
* Make readdir return DT_LNK for symlinks [#9].
* Make sure SIGCHLD is raised after a zombie for wait[pid] is created [#10].
* Make reaplath fail on non-existing paths [#11].
* Make stat succeed on file names with trailing spaces [#12].
* Make [f]close return 0 regardless of DosClose result if LIBC handle is freed [bitwiseworks/libcx#60].
* Fix typo in dlclose backend that would result in random return values [#14].
* Increase dlerror buffer to 260+64 chars (to fit the full DLL path).
* Fix LIBC makefiles to support building with GCC 4.x.x [#4].
* Remove libiberty headers and libs (newer ones are part of our binutils port) [#4].
* Align emxexp and innidmdll to newer libiberty from binutils [#4].
* Backport extern inline handling from newer GLIBC (2.28) [#4].
* Remove GCC 3 C++ library from LIBC DLL (our GCC 4 port provides a separate C++ DLL) [#4].
* Remove deprecated __STDC_CONSTANT_MACROS and __STDC_LIMIT_MACROS [#3, http://trac.netlabs.org/libc/ticket/297].
* Define max_align_t in stddef.h as required by ISO C [#3, http://trac.netlabs.org/libc/ticket/297].
* Fix LIBC_LOGGING processing by LIBC itself [#3, http://trac.netlabs.org/libc/ticket/361].
* Fix incorrect __KLIBC_ARG_MASK usage in __spawne [#3, http://trac.netlabs.org/libc/ticket/362].
* Reset global thread data in child after fork [#3, http://trac.netlabs.org/libc/ticket/363].
* Support more OS/2 APIRET codes when converting to errno [#3, http://trac.netlabs.org/libc/ticket/364].
* Add new __LIBC_FORK_CTX_FLAGS_LAST fork callback flag [#3, http://trac.netlabs.org/libc/ticket/366].
* emxomfld: Fix Invalid WKEXT record errors [#3, http://trac.netlabs.org/libc/ticket/376].
* Remove BSD defines from sys/param.h and types.h [#3, http://trac.netlabs.org/libc/ticket/377].
* Fix rare DosAllocMemEx(OBJ_LOCATION) bug [#3, http://trac.netlabs.org/libc/ticket/384].
* Remove /@unixroot/bin and /@unixroot/sbin from default paths [#15].
* Add NO_STRIP makefile variable to disable stripping debug info [#22].
* Fix LIBC makefiles to better support building LIBC RPMs [#24].
* Fix infinite loop in atexit, a GCC 4 regression [#25, #4].
* Properly define kHeapDbgException as weak symbol [#26, #4].
* Fix all compiler warnings under GCC 4 [#21].
* Fix incorrect process termination reason report in some cases [#21].
* Properly return old timer values in getitimer and setitimer APIs [#21].
* Fix parameter validation in waitid APIs [#21].
* Make __libc_TLSAlloc return ENOMEM when no memory instead of random errno [#21].
* Add getdents and getdirentries APIs [#27].
* Export __libc_native2errno from main DLL [#16].
* Add CMSG_LEN and CMSG_SPACE to sys/socket.h [#7].
* Add modern ISO C definition for NULL to stddef.h [#20].
* Update Safe DOS wrappers with ones from kLIBC 0.7 trunk [#24].
* Import emxomfstrip from kLIBC 0.7 trunk [#24].
* Add SafeDosEnumAttribute to libos2 [#19].
* Implement sysconf(_SC_NPROCESSORS_ONLN) [#5].
