/* $Id: $ */
/** @file
 * FreeBSD 5.1 + EMX
 *
 * @changed bird: EMX isms.
 * @changed bird: Removed (non KERNEL) stuff we don't implement and added
 *          EMX specific stuff.
 * @changed bird: Added sys/stat.h if in XSI mode.
 * @todo    Consider implementing the flags and commands we don't currently
 *          include.
 */


/*-
 * Copyright (c) 1983, 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)fcntl.h	8.3 (Berkeley) 1/21/94
 * $FreeBSD: src/sys/sys/fcntl.h,v 1.14 2002/09/17 22:22:50 mike Exp $
 */

#ifndef _SYS_FCNTL_H_
#define	_SYS_FCNTL_H_
#define	_SYS_FCNTL_H /* bird: EMX */

/*
 * This file includes the definitions for open and fcntl
 * described by POSIX for <fcntl.h>; it also includes
 * related kernel definitions.
 */

#include <sys/cdefs.h>
#include <sys/_types.h>
#if __XSI_VISIBLE       /* bird */
#include <sys/stat.h>   /* bird */
#endif                  /* bird */

#if !defined(_MODE_T_DECLARED) && !defined(_MODE_T)                             /* bird: EMX */
typedef	__mode_t	mode_t;
#define	_MODE_T_DECLARED
#define _MODE_T                                                                 /* bird: EMX */
#endif

#if !defined(_OFF_T_DECLARED) && !defined(_OFF_T)                               /* bird: EMX */
typedef	__off_t		off_t;
#define	_OFF_T_DECLARED
#define	_OFF_T                                                                  /* bird: EMX */
#endif

#if !defined(_PID_T_DECLARED) && !defined(_PID_T)                               /* bird: EMX */
typedef	__pid_t		pid_t;
#define	_PID_T_DECLARED
#define	_PID_T                                                                  /* bird: EMX */
#endif

/*
 * File status flags: these are used by open(2), fcntl(2).
 * They are also used (indirectly) in the kernel file structure f_flags,
 * which is a superset of the open/fcntl flags.  Open flags and f_flags
 * are inter-convertible using OFLAGS(fflags) and FFLAGS(oflags).
 * Open/fcntl flags begin with O_; kernel-internal flags begin with F.
 */
/* open-only flags */
#define	O_RDONLY	0x0000		/* open for reading only */
#define	O_WRONLY	0x0001		/* open for writing only */
#define	O_RDWR		0x0002		/* open for reading and writing */
#define	O_ACCMODE	0x0003		/* mask for above modes */

/*
 * Kernel encoding of open mode; separate read and write bits that are
 * independently testable: 1 greater than the above.
 *
 * XXX
 * FREAD and FWRITE are excluded from the #ifdef _KERNEL so that TIOCFLUSH,
 * which was documented to use FREAD/FWRITE, continues to work.
 */
#if __BSD_VISIBLE
#ifndef FREAD  /* bird: safety */
#define	FREAD		0x0001
#define	FWRITE		0x0002
#endif
#endif         /* bird: safety */
#define	O_NONBLOCK	0x0004		/* no delay */
#define	O_APPEND	0x0008		/* set append mode */
#if __BSD_VISIBLE
#if 0  /* bird: not implemented - start */
#define	O_SHLOCK	0x0010		/* open with shared file lock */
#define	O_EXLOCK	0x0020		/* open with exclusive file lock */
#define	O_ASYNC		0x0040		/* signal pgrp when data ready */
#endif /* bird: not implemented - end */
#define	O_FSYNC		0x0080		/* synchronous writes */
#endif
/* bird: EMX used 0x2000 for O_SYNC. */
#define	O_SYNC		0x0080		/* POSIX synonym for O_FSYNC */
#if __BSD_VISIBLE
#define	O_NOFOLLOW	0x0100		/* don't follow symlinks */
#endif
#define	O_CREAT		0x0200		/* create if nonexistent */
#define	O_TRUNC		0x0400		/* truncate to zero length */
#define	O_EXCL		0x0800		/* error if already exists */
#ifdef _KERNEL
/* FMARK/FDEFER kept in f_gcflags */
#define	FMARK		0x1		/* mark during gc() */
#define	FDEFER		0x2		/* defer for next gc pass */
#define	FHASLOCK	0x4000		/* descriptor holds advisory lock */
#endif

/* Defined by POSIX 1003.1; BSD default, but must be distinct from O_RDONLY. */
/* bird: EMX used 0x4000 for O_NOCTTY. */
#define	O_NOCTTY	0x8000		/* don't assign controlling terminal */

#if __BSD_VISIBLE
/* Attempt to bypass buffer cache */
#define O_DIRECT	0x00010000
#endif

/*
 * XXX missing O_DSYNC, O_RSYNC.
 */

#ifdef _KERNEL
/* convert from open() flags to/from fflags; convert O_RD/WR to FREAD/FWRITE */
#define	FFLAGS(oflags)	((oflags) + 1)
#define	OFLAGS(fflags)	((fflags) - 1)

/* bits to save after open */
#define	FMASK		(FREAD|FWRITE|FAPPEND|FASYNC|FFSYNC|FNONBLOCK|O_DIRECT)
/* bits settable by fcntl(F_SETFL, ...) */
#define	FCNTLFLAGS	(FAPPEND|FASYNC|FFSYNC|FNONBLOCK|FPOSIXSHM|O_DIRECT)
#endif

/*
 * The O_* flags used to have only F* names, which were used in the kernel
 * and by fcntl.  We retain the F* names for the kernel f_flag field
 * and for backward compatibility for fcntl.  These flags are deprecated.
 */
#if __BSD_VISIBLE
#define	FAPPEND		O_APPEND	/* kernel/compat */
#if 0  /* bird: not implemented - start */
#define	FASYNC		O_ASYNC		/* kernel/compat */
#endif /* bird: not implemented - end */
#define	FFSYNC		O_FSYNC		/* kernel */
#define	FNONBLOCK	O_NONBLOCK	/* kernel */
#define	FNDELAY		O_NONBLOCK	/* compat */
#define	O_NDELAY	O_NONBLOCK	/* compat */
#endif

#if 0  /* bird: not implemented - start */
/*
 * We are out of bits in f_flag (which is a short).  However,
 * the flag bits not set in FMASK are only meaningful in the
 * initial open syscall.  Those bits can thus be given a
 * different meaning for fcntl(2).
 */
#if __BSD_VISIBLE

/*
 * Set by shm_open(3) to get automatic MAP_ASYNC behavior
 * for POSIX shared memory objects (which are otherwise
 * implemented as plain files).
 */
#define	FPOSIXSHM	O_NOFOLLOW
#endif
#endif /* bird: not implemented - end */

/*
 * Constants used for fcntl(2)
 */

/* command values */
/* bird: EMX used 5 for F_DUPFD. */
#define	F_DUPFD		0		/* duplicate file descriptor */
/* bird: EMX used 3 for F_GETFD. */
#define	F_GETFD		1		/* get file descriptor flags */
/* bird: EMX used 4 for F_SETFD. */
#define	F_SETFD		2		/* set file descriptor flags */
/* bird: EMX used 1 for F_GETFL. */
#define	F_GETFL		3		/* get file status flags */
/* bird: EMX used 2 for F_SETFL. */
#define	F_SETFL		4		/* set file status flags */
#if 0  /* bird: not implemented - start */
#if __BSD_VISIBLE || __XSI_VISIBLE || __POSIX_VISIBLE >= 200112
#define	F_GETOWN	5		/* get SIGIO/SIGURG proc/pgrp */
#define F_SETOWN	6		/* set SIGIO/SIGURG proc/pgrp */
#endif
#endif /* bird: not implemented - end */
#define	F_GETLK		7		/* get record locking information */
#define	F_SETLK		8		/* set record locking information */
#define	F_SETLKW	9		/* F_SETLK; wait if blocked */
#if __BSD_VISIBLE /* NOTE: we actually take these from _NETBSD_SOURCE */
#define	F_CLOSEM	10		/* close all fds >= to the one given */
#define	F_MAXFD		11		/* return the max open fd */
#endif

/* file descriptor flags (F_GETFD, F_SETFD) */
#define	FD_CLOEXEC	1		/* close-on-exec flag */

/* record locking flags (F_GETLK, F_SETLK, F_SETLKW) */
#define	F_RDLCK		1		/* shared or read lock */
#define	F_UNLCK		2		/* unlock */
#define	F_WRLCK		3		/* exclusive or write lock */
#ifdef _KERNEL
#define	F_WAIT		0x010		/* Wait until lock is granted */
#define	F_FLOCK		0x020	 	/* Use flock(2) semantics for lock */
#define	F_POSIX		0x040	 	/* Use POSIX semantics for lock */
#endif

/*
 * Advisory file segment locking data type -
 * information passed to system by user
 */
struct flock {
	off_t	l_start;	/* starting offset */
	off_t	l_len;		/* len = 0 means until end of file */
	pid_t	l_pid;		/* lock owner */
	short	l_type;		/* lock type: read/write, etc. */
	short	l_whence;	/* type of l_start */
};


#if __BSD_VISIBLE
/* lock operations for flock(2) */
#define	LOCK_SH		0x01		/* shared file lock */
#define	LOCK_EX		0x02		/* exclusive file lock */
#define	LOCK_NB		0x04		/* don't block when locking */
#define	LOCK_UN		0x08		/* unlock file */
#endif

/*
 * XXX missing posix_fadvise() and posix_fallocate(), and POSIX_FADV_* macros.
 */

#ifndef _KERNEL
__BEGIN_DECLS
int	open(const char *, int, ...);
int	creat(const char *, mode_t);
int	fcntl(int, int, ...);
#if __BSD_VISIBLE
int	flock(int, int);
#endif
__END_DECLS
#endif

/* bird: EMX stuff - start */
#if !defined (O_TEXT)
/* Open flags.
 *      There is some limits to the available bits, generally FreeBSD limits
 *      it's range to the first 16-bits. See emx\io.h for the complete
 *      assignments.
 */
#define O_BINARY    0x00020000
#define O_TEXT      0x00040000
#define O_SIZE      0x00080000
#if !defined (_POSIX_SOURCE) || defined(__USE_EMX)
#define O_NOINHERIT 0x00001000
#endif
#endif

#if !defined (F_OK) /* bird: Really defined in unistd.h, but Linux and EMX does it here too. */
/* access function */
#define	F_OK		0	/* test for existence of file */
#define	X_OK		0x01	/* test for execute or search permission */
#define	W_OK		0x02	/* test for write permission */
#define	R_OK		0x04	/* test for read permission */
#endif

#if !defined (_POSIX_SOURCE) || defined (_WITH_UNDERSCORE) || defined(__USE_EMX)
__BEGIN_DECLS
int _creat (const char *, int);
int _fcntl (int, int, ...);
int _flock (int, int);
int _open (const char *, int, ...);
__END_DECLS
#endif
/* bird: EMX stuff - end */

#endif /* !_SYS_FCNTL_H_ */
